/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.blocks.BasePlantBlock;
import org.betterx.bclib.interfaces.SurvivesOnBlocks;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.LootUtil;
import org.betterx.bclib.util.MHelper;

public class BaseCropBlock
extends BasePlantBlock
implements SurvivesOnBlocks {
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)3);
    private static final VoxelShape SHAPE = BaseCropBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    private final List<Block> terrain;
    private final Item drop;

    public BaseCropBlock(Item drop, Block ... terrain) {
        this(BehaviourBuilders.createPlant().m_60977_().m_60918_(SoundType.f_56758_).m_222979_(BlockBehaviour.OffsetType.XZ), drop, terrain);
    }

    protected BaseCropBlock(BlockBehaviour.Properties properties, Item drop, Block ... terrain) {
        super(properties);
        this.drop = drop;
        this.terrain = List.of(terrain);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{AGE});
    }

    @Override
    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        int enchantment;
        if ((Integer)state.m_61143_((Property)AGE) < 3) {
            return Collections.singletonList(new ItemStack((ItemLike)this));
        }
        ItemStack tool = (ItemStack)builder.m_287261_(LootContextParams.f_81463_);
        if (LootUtil.isCorrectTool((ItemLike)this, state, tool) && (enchantment = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)tool)) > 0) {
            int countSeeds = MHelper.randRange(Mth.m_14045_((int)(1 + enchantment), (int)1, (int)3), 3, MHelper.RANDOM_SOURCE);
            int countDrops = MHelper.randRange(Mth.m_14045_((int)(1 + enchantment), (int)1, (int)2), 2, MHelper.RANDOM_SOURCE);
            return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)this, countSeeds), new ItemStack((ItemLike)this.drop, countDrops)});
        }
        int countSeeds = MHelper.randRange(1, 3, MHelper.RANDOM_SOURCE);
        int countDrops = MHelper.randRange(1, 2, MHelper.RANDOM_SOURCE);
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)this, countSeeds), new ItemStack((ItemLike)this.drop, countDrops)});
    }

    @Override
    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        int age = (Integer)state.m_61143_((Property)AGE);
        if (age < 3) {
            BlocksHelper.setWithUpdate((LevelAccessor)level, pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)));
        }
    }

    @Override
    public boolean m_7370_(LevelReader world, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.m_61143_((Property)AGE) < 3;
    }

    @Override
    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) < 3;
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.m_213897_(state, world, pos, random);
        if (this.m_214167_((Level)world, random, pos, state) && random.m_188503_(8) == 0) {
            this.m_214148_(world, random, pos, state);
        }
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return SHAPE;
    }

    @Override
    public List<Block> getSurvivableBlocks() {
        return this.terrain;
    }

    @Override
    public boolean isTerrain(BlockState state) {
        return SurvivesOnBlocks.super.isTerrain(state);
    }
}

